datacache <- new.env(hash=TRUE, parent=emptyenv())

xlaevis <- function() showQCData("xlaevis", datacache)
xlaevis_dbconn <- function() dbconn(datacache)
xlaevis_dbfile <- function() dbfile(datacache)
xlaevis_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
xlaevis_dbInfo <- function() dbInfo(datacache)

xlaevisORGANISM <- "Xenopus laevis"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "xlaevis.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("XENOPUSCHIP_DB", "xlaevis", "chip xlaevis", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("xlaevis.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(xlaevis_dbconn())
}

