% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInfo.R
\name{findGenesByEntrez}
\alias{findGenesByEntrez}
\title{Internal Gene representation for given list of gene Entrez IDs}
\usage{
findGenesByEntrez(entrez)
}
\arguments{
\item{entrez}{\code{vector} of Entres IDs. Function accepts both
integers and characters.}
}
\value{
\code{data.frame} with columns specified above.
}
\description{
Get internal gene representation for set of gene Entrez IDs.
Function lookups for provided values in Human Entrez ID, Mouse Entrez ID
and Rat Entrez ID columns and return following features for all found
genes: GeneID (internal database ID), MGI ID, Human Entrez ID, Mouse
Entrez ID, Rat Entrez ID, Human gene name, Mouse gene name and Rat
gene name.
}
\details{
Could be used as an intermediate step for building Protein-Protein
interaction map from the list of Gene IDs returned in the first column.
Also, this function provides a useful sanity check, e.g. how many Gene IDs
correspond to the
specific gene name or Entrez ID, which could be specie-specific.
}
\examples{
# get information for specific gene
t <- findGenesByEntrez(c(1742, 1741, 1739, 1740))
}
\seealso{
Other {Lookup functions}: 
\code{\link{findGenesByName}()}

Other {Gene functions}: 
\code{\link{findGeneByCompartmentPaperCnt}()},
\code{\link{findGeneByPaperCnt}()},
\code{\link{findGeneByPapers}()},
\code{\link{findGenesByName}()},
\code{\link{getAllGenes4Compartment}()},
\code{\link{getGenes4Compartment}()},
\code{\link{getGenesByID}()}
}
\concept{{Gene functions}}
\concept{{Lookup functions}}
