
\name{rgu34b_dbconn}

\alias{rgu34b_dbconn}
\alias{rgu34b_dbfile}
\alias{rgu34b_dbschema}
\alias{rgu34b_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  rgu34b_dbconn()
  rgu34b_dbfile()
  rgu34b_dbschema(file="", show.indices=FALSE)
  rgu34b_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{rgu34b_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{rgu34b_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{rgu34b_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{rgu34b_dbschema} prints the schema definition of the
  package annotation DB.

  \code{rgu34b_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{rgu34b_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{rgu34b_dbfile}: a character string with the path to the
  package annotation DB.

  \code{rgu34b_dbschema}: none (invisible \code{NULL}).

  \code{rgu34b_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(rgu34b_dbconn(), "SELECT COUNT(*) FROM probes")

  rgu34b_dbschema()

  rgu34b_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

