datacache <- new.env(hash=TRUE, parent=emptyenv())

ragene21sttranscriptcluster <- function() showQCData("ragene21sttranscriptcluster", datacache)
ragene21sttranscriptcluster_dbconn <- function() dbconn(datacache)
ragene21sttranscriptcluster_dbfile <- function() dbfile(datacache)
ragene21sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
ragene21sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

ragene21sttranscriptclusterORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "ragene21sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "ragene21sttranscriptcluster", "chip ragene21sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("ragene21sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(ragene21sttranscriptcluster_dbconn())
}

