datacache <- new.env(hash=TRUE, parent=emptyenv())

raex10sttranscriptcluster <- function() showQCData("raex10sttranscriptcluster", datacache)
raex10sttranscriptcluster_dbconn <- function() dbconn(datacache)
raex10sttranscriptcluster_dbfile <- function() dbfile(datacache)
raex10sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
raex10sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

raex10sttranscriptclusterORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "raex10sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "raex10sttranscriptcluster", "chip raex10sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("raex10sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(raex10sttranscriptcluster_dbconn())
}

