datacache <- new.env(hash=TRUE, parent=emptyenv())

pedbarrayv10 <- function() showQCData("pedbarrayv10", datacache)
pedbarrayv10_dbconn <- function() dbconn(datacache)
pedbarrayv10_dbfile <- function() dbfile(datacache)
pedbarrayv10_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
pedbarrayv10_dbInfo <- function() dbInfo(datacache)

pedbarrayv10ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "pedbarrayv10.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "pedbarrayv10", "chip pedbarrayv10", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("pedbarrayv10.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(pedbarrayv10_dbconn())
}

