datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Pf.plasmo <- function() showQCData("org.Pf.plasmo", datacache)
org.Pf.plasmo_dbconn <- function() dbconn(datacache)
org.Pf.plasmo_dbfile <- function() dbfile(datacache)
org.Pf.plasmo_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Pf.plasmo_dbInfo <- function() dbInfo(datacache)

org.Pf.plasmoORGANISM <- "Plasmodium falciparum"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Pf.plasmo.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MALARIA_DB", "org.Pf.plasmo", "Malaria", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Pf.plasmo.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Pf.plasmo_dbconn())
}

