\name{org.At.tairSYMBOL}
\alias{org.At.tairSYMBOL}
\title{Map between TAIR Identifiers and Gene Symbols}
\description{
  org.At.tairSYMBOL is an R object that provides mappings between
  TAIR identifiers and gene abbreviations. 
}
\details{
  Each TAIR identifier is mapped to an abbreviation for the
  corresponding gene. An \code{NA} is reported if there is no known
  abbreviation for a given gene.
  
  Symbols typically consist of 3 letters that define either a single
  gene (ABC) or multiple genes (ABC1, ABC2, ABC3). Gene symbols can be
  used as key words to query public databases such as Entrez Gene.
  
  Mappings were based on data provided by: Tair  
  https://www.arabidopsis.org/api/download-files/download?filePath=Public\_Data\_Releases/TAIR\_Data\_20230630/gene\_aliases\_20230630.txt.gz  
  With a date stamp from the source of: 2025-09-24
  
}

\references{
  \url{https://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene}
}

\seealso{
  \itemize{
    \item \code{\link[AnnotationDbi]{AnnotationDb-class}} for use of
          the \code{select()} interface.
  }
}

\examples{
## select() interface:
## Objects in this package can be accessed using the select() interface
## from the AnnotationDbi package. See ?select for details.

## Bimap interface:
x <- org.At.tairSYMBOL
# Get the tair identifiers that are mapped to a gene symbol
mapped_genes <- mappedkeys(x)
# Convert to a list
xx <- as.list(x[mapped_genes])
if(length(xx) > 0) {
  # Get the SYMBOL for the first five genes
  xx[1:5]
  # Get the first one
  xx[[1]]
}
}

\keyword{datasets}

