datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Ag.eg <- function() showQCData("org.Ag.eg", datacache)
org.Ag.eg_dbconn <- function() dbconn(datacache)
org.Ag.eg_dbfile <- function() dbfile(datacache)
org.Ag.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Ag.eg_dbInfo <- function() dbInfo(datacache)

org.Ag.egORGANISM <- "Anopheles gambiae"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Ag.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ANOPHELES_DB", "org.Ag.eg", "Anopheles", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Ag.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Ag.eg_dbconn())
}

