datacache <- new.env(hash=TRUE, parent=emptyenv())

nugomm1a520177 <- function() showQCData("nugomm1a520177", datacache)
nugomm1a520177_dbconn <- function() dbconn(datacache)
nugomm1a520177_dbfile <- function() dbfile(datacache)
nugomm1a520177_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
nugomm1a520177_dbInfo <- function() dbInfo(datacache)

nugomm1a520177ORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "nugomm1a520177.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "nugomm1a520177", "chip nugomm1a520177", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("nugomm1a520177.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(nugomm1a520177_dbconn())
}

