datacache <- new.env(hash=TRUE, parent=emptyenv())

mogene21stprobeset <- function() showQCData("mogene21stprobeset", datacache)
mogene21stprobeset_dbconn <- function() dbconn(datacache)
mogene21stprobeset_dbfile <- function() dbfile(datacache)
mogene21stprobeset_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mogene21stprobeset_dbInfo <- function() dbInfo(datacache)

mogene21stprobesetORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mogene21stprobeset.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mogene21stprobeset", "chip mogene21stprobeset", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mogene21stprobeset.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mogene21stprobeset_dbconn())
}

