datacache <- new.env(hash=TRUE, parent=emptyenv())

mogene11sttranscriptcluster <- function() showQCData("mogene11sttranscriptcluster", datacache)
mogene11sttranscriptcluster_dbconn <- function() dbconn(datacache)
mogene11sttranscriptcluster_dbfile <- function() dbfile(datacache)
mogene11sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mogene11sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

mogene11sttranscriptclusterORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mogene11sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mogene11sttranscriptcluster", "chip mogene11sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mogene11sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mogene11sttranscriptcluster_dbconn())
}

