
\name{moex10stprobeset_dbconn}

\alias{moex10stprobeset_dbconn}
\alias{moex10stprobeset_dbfile}
\alias{moex10stprobeset_dbschema}
\alias{moex10stprobeset_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  moex10stprobeset_dbconn()
  moex10stprobeset_dbfile()
  moex10stprobeset_dbschema(file="", show.indices=FALSE)
  moex10stprobeset_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{moex10stprobeset_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{moex10stprobeset_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{moex10stprobeset_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{moex10stprobeset_dbschema} prints the schema definition of the
  package annotation DB.

  \code{moex10stprobeset_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{moex10stprobeset_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{moex10stprobeset_dbfile}: a character string with the path to the
  package annotation DB.

  \code{moex10stprobeset_dbschema}: none (invisible \code{NULL}).

  \code{moex10stprobeset_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(moex10stprobeset_dbconn(), "SELECT COUNT(*) FROM probes")

  moex10stprobeset_dbschema()

  moex10stprobeset_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

