datacache <- new.env(hash=TRUE, parent=emptyenv())

mm24kresogen <- function() showQCData("mm24kresogen", datacache)
mm24kresogen_dbconn <- function() dbconn(datacache)
mm24kresogen_dbfile <- function() dbfile(datacache)
mm24kresogen_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
mm24kresogen_dbInfo <- function() dbInfo(datacache)

mm24kresogenORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "mm24kresogen.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "mm24kresogen", "chip mm24kresogen", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("mm24kresogen.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(mm24kresogen_dbconn())
}

