\name{lumiMouseIDMapping_nuID}

\alias{lumiMouseIDMapping_nuID}

\title{Mapping nuIDs of Illumina Mouse chips to the most recent Mus musculus RefSeq release}

\description{
  We mapped nuIDs of Illumina Mouse chips by BLASTing each probe sequence (converted from nuID) against the the most recent Mus musculus RefSeq release. The mapping also includes the mapping quality information.
}

\usage{
  lumiMouseIDMapping_nuID()
}

\arguments{
}

\details{
The nuID mapping information is kept in the nuID\_MappingInfo table in the ID Mapping library. The nuID mapping table includes following fields (columns):

1. 	nuID: nuID for the probe sequence

2. 	Refseq: The refseq IDs with perfect matching with probe sequence. If there are more than one refseq IDs, they are separated by ",".

3. 	EntrezID: The Entrez gene IDs correspond to the refseq IDs. If there are more than one Entrez gene IDs, they are separated by ",". 

4. 	QualityScore: The mapping quality from probe sequence to RefSeq, see reference 2 for more details.

5.  Refseq\_old: the refseq ID provided by Illumina company when they designed the chip (included in the chip manifest file).


For the version after 1.4.0, the mapping information was got from the Computational Biology Group at University of Cambridge, see reference link for more details.

}

\value{
 \code{lumiMouseIDMapping_nuID} returns a nuID mapping summary of Illumina Mouse chips.
}

\references{
1. Du, P., Kibbe, W.A. and Lin, S.M., "nuID: A universal naming schema of oligonucleotides for Illumina, Affymetrix, and other microarrays", Biology Direct 2007, 2:16 (31May2007).
2. http://www.compbio.group.cam.ac.uk/Resources/Annotation/index.html
}
\seealso{

}

\examples{
  ## List the fields in the nuID_MappingInfo table
  conn <- lumiMouseIDMapping_dbconn()
  dbListFields(conn, 'nuID_MappingInfo')

  ## Summary of nuID mapping
  lumiMouseIDMapping_nuID()

}

\keyword{utilities}
\keyword{datasets}

