
\name{lumiMouseAll_dbconn}

\alias{lumiMouseAll_dbconn}
\alias{lumiMouseAll_dbfile}
\alias{lumiMouseAll_dbschema}
\alias{lumiMouseAll_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  lumiMouseAll_dbconn()
  lumiMouseAll_dbfile()
  lumiMouseAll_dbschema(file="", show.indices=FALSE)
  lumiMouseAll_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{lumiMouseAll_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{lumiMouseAll_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{lumiMouseAll_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{lumiMouseAll_dbschema} prints the schema definition of the
  package annotation DB.

  \code{lumiMouseAll_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{lumiMouseAll_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{lumiMouseAll_dbfile}: a character string with the path to the
  package annotation DB.

  \code{lumiMouseAll_dbschema}: none (invisible \code{NULL}).

  \code{lumiMouseAll_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(lumiMouseAll_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by lumiMouseAll_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=lumiMouseAll_dbfile(), cache_size=64000,
  synchronous=0)

  lumiMouseAll_dbschema()

  lumiMouseAll_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

