datacache <- new.env(hash=TRUE, parent=emptyenv())

lumiMouseAll <- function() showQCData("lumiMouseAll", datacache)
lumiMouseAll_dbconn <- function() dbconn(datacache)
lumiMouseAll_dbfile <- function() dbfile(datacache)
lumiMouseAll_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
lumiMouseAll_dbInfo <- function() dbInfo(datacache)

lumiMouseAllORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "lumiMouseAll.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "lumiMouseAll", "chip lumiMouseAll", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("lumiMouseAll.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(lumiMouseAll_dbconn())
}

