\name{lumiHumanIDMapping_dbconn}

\alias{lumiHumanIDMapping_dbconn}
\alias{lumiHumanIDMapping_dbfile}
\alias{lumiHumanIDMapping_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  lumiHumanIDMapping_dbconn()
  lumiHumanIDMapping_dbfile()
  lumiHumanIDMapping_dbInfo()
}

\arguments{
 
}

\details{
  \code{lumiHumanIDMapping_dbconn} returns a connection object to the package
  annotation DB.
  IMPORTANT: Don't call \code{\link[DBI]{dbDisconnect}} on the connection
  object returned by \code{lumiHumanIDMapping_dbconn} or you will
  break all the \code{\link[AnnotationDbi]{AnnDbObj}} objects defined in this package!

  \code{lumiHumanIDMapping_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{lumiHumanIDMapping_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{lumiHumanIDMapping_dbconn}: a DBIConnection object representing an open
  connection to the package annotation DB.

  \code{lumiHumanIDMapping_dbfile}: a character string with the path to the
  package annotation DB.

  \code{lumiHumanIDMapping_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI]{dbConnect}}
}

\examples{
  ## Show the database information (meta data)
  lumiHumanIDMapping_dbInfo()  

  ## List the tables included in the database
  library(DBI)
  conn <- lumiHumanIDMapping_dbconn()
  dbListTables(conn)
}

\keyword{utilities}
\keyword{datasets}

