datacache <- new.env(hash=TRUE, parent=emptyenv())

lumiHumanAll <- function() showQCData("lumiHumanAll", datacache)
lumiHumanAll_dbconn <- function() dbconn(datacache)
lumiHumanAll_dbfile <- function() dbfile(datacache)
lumiHumanAll_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
lumiHumanAll_dbInfo <- function() dbInfo(datacache)

lumiHumanAllORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "lumiHumanAll.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "lumiHumanAll", "chip lumiHumanAll", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("lumiHumanAll.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(lumiHumanAll_dbconn())
}

