\name{illuminaRatv1listNewMappings}
\alias{illuminaRatv1ARRAYADDRESS}
\alias{illuminaRatv1NUID}
\alias{illuminaRatv1PROBESEQUENCE}
\alias{illuminaRatv1PROBEQUALITY}
\alias{illuminaRatv1CODINGZONE}
\alias{illuminaRatv1GENOMICLOCATION}
\alias{illuminaRatv1GENOMICMATCHSIMILARITY}
\alias{illuminaRatv1SECONDMATCHES}
\alias{illuminaRatv1SECONDMATCHSIMILARITY}
\alias{illuminaRatv1TRANSCRIPTOMICMATCHSIMILARITY}
\alias{illuminaRatv1OTHERGENOMICMATCHES}
\alias{illuminaRatv1REPEATMASK}
\alias{illuminaRatv1OVERLAPPINGSNP}
\alias{illuminaRatv1ENTREZREANNOTATED}
\alias{illuminaRatv1ENSEMBLREANNOTATED}
\alias{illuminaRatv1SYMBOLREANNOTATED}
\alias{illuminaRatv1listNewMappings}
\alias{illuminaRatv1fullReannotation}
\alias{illuminaRatv1REPORTERGROUPNAME}
\alias{illuminaRatv1REPORTERGROUPID}

\title{Custom mappings added to the package}
\description{
We have used an extensive re-annotation of the illuminaRatv1 probe sequences to provide additional information that is not captured in the standard Bioconductor packages. Whereas Bioconductor annotations are based on the RefSeq ID that each probe maps to, our additional mappings provide data specific to each probe on the platform. See below for details. We recommend using the probe quality as a form of filtering, and retaining only perfect or good probes for an analysis. 

}

\section{Details of custom mappings}{

\describe{

\item{illuminaRatv1listNewMappings}{List all the custom re-annotation mappings provided by the package}

\item{illuminaRatv1fullReannotation}{Return all the re-annotation information as a matrix}

\item{illuminaRatv1ARRAYADDRESS}{Array Address code used to identify the probe at the bead-level}

\item{illuminaRatv1NUID}{Lumi's nuID (universal naming scheme for oligonucleotides) Reference: Du et al. (2007), Biol Direct 2:16}

\item{illuminaRatv1PROBESEQUENCE}{The 50 base sequence for the probe}

\item{illuminaRatv1PROBEQUALITY}{Quality grade assigned to the probe: \dQuote{Perfect} if it perfectly and uniquely matches the target transcript; \dQuote{Good} if the probe, although imperfectly matching the target transcript, is still likely to provide considerably sensitive signal (up to two mismatches are allowed, based on empirical evidence that the signal intensity for 50-mer probes with less than 95\% identity to the respective targets is less than 50\% of the signal associated with perfect matches *); \dQuote{Bad} if the probe matches repeat sequences, intergenic or intronic regions, or is unlikely to provide specific signal for any transcript; \dQuote{No match} if it does not match any genomic region or transcript.}

\item{illuminaRatv1CODINGZONE}{Coding status of target sequence: intergenic / intronic / Transcriptomic (\dQuote{Transcriptomic} when the target transcript is non-coding or there is no information on the coding sequence)}

\item{illuminaRatv1GENOMICLOCATION}{Probe's genomic coordinates (hg19 for human, mm9 for mouse or rn4 for rat)}

\item{illuminaRatv1GENOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its best genomic match in the alignable region, taking the probe as reference}

\item{illuminaRatv1SECONDMATCHES}{Genomic coordinates of second best matches between the probe and the genome}

\item{illuminaRatv1SECONDMATCHSIMILARITY}{Percentage of similarity between the probe and its second best genomic match in the alignable region, taking the probe as reference}

\item{illuminaRatv1TRANSCRIPTOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its target transcript in the alignable region, taking the probe as reference}

\item{illuminaRatv1OTHERGENOMICMATCHES}{Genomic coordinates of sequences as alignable with the probe (in terms of number of matching nucleotides) as its main target}

\item{illuminaRatv1REPEATMASK}{Overlapping RepeatMasked sequences, with number of bases overlapped by the repeat}

\item{illuminaRatv1OVERLAPPINGSNP}{Overlapping annotated SNPs}

\item{illuminaRatv1ENTREZREANNOTATED}{Entrez IDs}

\item{illuminaRatv1ENSEMBLREANNOTATED}{Ensembl IDs}

\item{illuminaRatv1SYMBOLREANNOTATED}{Gene symbol derived by re-annotation}

\item{illuminaRatv1REPORTERGROUPID}{For probes marked as controls in Illuminas annotation file, these gives the type of control}

\item{illuminaRatv1REPORTERGROUPNAME}{Usually a more informative name for the control type}



}

}

\references{
  \url{http://remoat.sysbiol.cam.ac.uk}


 Barbosa-Morais et al. (2010) A re-annotation pipeline for Illumina BeadArrays: improving the interpretation of gene expression data. Nucleic Acids Research

}
\examples{

	##See what new mappings are available

	illuminaRatv1listNewMappings()
	

        x <- illuminaRatv1PROBEQUALITY

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBEQUALITY for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


	##Overall table of qualities
	table(unlist(xx))

	

        x <- illuminaRatv1ARRAYADDRESS

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

	##Can do the mapping from array address to illumina ID using a revmap
	
	y<- revmap(illuminaRatv1ARRAYADDRESS)
	
        mapped_probes <- mappedkeys(y)
        # Convert to a list
        yy <- as.list(y[mapped_probes])
        if(length(yy) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          yy[1:5]
          # Get the first one
          yy[[1]]
        }
	


        x <- illuminaRatv1CODINGZONE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the CODINGZONE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        x <- illuminaRatv1PROBESEQUENCE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBESEQUENCE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


}
\keyword{datasets}
