datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaRatv1 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaRatv1", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaRatv4listNewMappings()

}

illuminaRatv1_dbconn <- function() dbconn(datacache)
illuminaRatv1_dbfile <- function() dbfile(datacache)
illuminaRatv1_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaRatv1_dbInfo <- function() dbInfo(datacache)

illuminaRatv1ORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaRatv1.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "illuminaRatv1", "chip illuminaRatv1", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaRatv1.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaRatv1_dbconn())
}

##Custom Bimaps for the package

illuminaRatv1ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaRatv1.db")

illuminaRatv1NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaRatv1.db")

illuminaRatv1PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaRatv1.db")

illuminaRatv1CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaRatv1.db")

illuminaRatv1PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaRatv1.db")

illuminaRatv1SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaRatv1.db")

illuminaRatv1OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaRatv1.db")

illuminaRatv1REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaRatv1.db")

illuminaRatv1OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaRatv1.db")

illuminaRatv1ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaRatv1.db")

illuminaRatv1GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaRatv1.db")

illuminaRatv1SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaRatv1.db")

illuminaRatv1REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaRatv1.db")

illuminaRatv1REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaRatv1.db")

illuminaRatv1ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaRatv1.db")

illuminaRatv1listNewMappings = function(){
cat("illuminaRatv1ARRAYADDRESS()\n") 
cat("illuminaRatv1NUID()\n") 
cat("illuminaRatv1PROBEQUALITY()\n") 
cat("illuminaRatv1CODINGZONE()\n") 
cat("illuminaRatv1PROBESEQUENCE()\n") 
cat("illuminaRatv1SECONDMATCHES()\n") 
cat("illuminaRatv1OTHERGENOMICMATCHES()\n") 
cat("illuminaRatv1REPEATMASK()\n") 
cat("illuminaRatv1OVERLAPPINGSNP()\n") 
cat("illuminaRatv1ENTREZREANNOTATED()\n") 
cat("illuminaRatv1GENOMICLOCATION()\n") 
cat("illuminaRatv1SYMBOLREANNOTATED()\n") 
cat("illuminaRatv1REPORTERGROUPNAME()\n") 
cat("illuminaRatv1REPORTERGROUPID()\n") 
cat("illuminaRatv1ENSEMBLREANNOTATED()\n") 
}
illuminaRatv1fullReannotation = function(){
dbGetQuery(illuminaRatv1_dbconn(), "SELECT * FROM ExtraInfo")
}
