datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaMousev2 <- function() {
cat("####Mappings based on RefSeqID####\n")
showQCData("illuminaMousev2", datacache)
cat("####Custom Mappings based on probe sequence####\n")
illuminaMousev2listNewMappings()
}
illuminaMousev2_dbconn <- function() dbconn(datacache)
illuminaMousev2_dbfile <- function() dbfile(datacache)
illuminaMousev2_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaMousev2_dbInfo <- function() dbInfo(datacache)

illuminaMousev2ORGANISM <- "Mus musculus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaMousev2.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("MOUSECHIP_DB", "illuminaMousev2", "chip illuminaMousev2", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaMousev2.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaMousev2_dbconn())
}

##Custom Bimaps for the package

illuminaMousev2ARRAYADDRESS <- createSimpleBimap("ExtraInfo", "IlluminaID","ArrayAddress", datacache, "ARRAYADDRESS","illuminaMousev2.db")

illuminaMousev2NUID <- createSimpleBimap("ExtraInfo", "IlluminaID","NuID", datacache, "NUID","illuminaMousev2.db")

illuminaMousev2PROBEQUALITY <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeQuality", datacache, "PROBEQUALITY","illuminaMousev2.db")

illuminaMousev2CODINGZONE <- createSimpleBimap("ExtraInfo", "IlluminaID","CodingZone", datacache, "CODINGZONE","illuminaMousev2.db")

illuminaMousev2PROBESEQUENCE <- createSimpleBimap("ExtraInfo", "IlluminaID","ProbeSequence", datacache, "PROBESEQUENCE","illuminaMousev2.db")

illuminaMousev2SECONDMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","SecondMatches", datacache, "SECONDMATCHES","illuminaMousev2.db")

illuminaMousev2OTHERGENOMICMATCHES <- createSimpleBimap("ExtraInfo", "IlluminaID","OtherGenomicMatches", datacache, "OTHERGENOMICMATCHES","illuminaMousev2.db")

illuminaMousev2REPEATMASK <- createSimpleBimap("ExtraInfo", "IlluminaID","RepeatMask", datacache, "REPEATMASK","illuminaMousev2.db")

illuminaMousev2OVERLAPPINGSNP <- createSimpleBimap("ExtraInfo", "IlluminaID","OverlappingSNP", datacache, "OVERLAPPINGSNP","illuminaMousev2.db")

illuminaMousev2ENTREZREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EntrezReannotated", datacache, "ENTREZREANNOTATED","illuminaMousev2.db")

illuminaMousev2GENOMICLOCATION <- createSimpleBimap("ExtraInfo", "IlluminaID","GenomicLocation", datacache, "GENOMICLOCATION","illuminaMousev2.db")

illuminaMousev2SYMBOLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","SymbolReannotated", datacache, "SYMBOLREANNOTATED","illuminaMousev2.db")

illuminaMousev2REPORTERGROUPNAME <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupName", datacache, "REPORTERGROUPNAME","illuminaMousev2.db")

illuminaMousev2REPORTERGROUPID <- createSimpleBimap("ExtraInfo", "IlluminaID","ReporterGroupID", datacache, "REPORTERGROUPID","illuminaMousev2.db")

illuminaMousev2ENSEMBLREANNOTATED <- createSimpleBimap("ExtraInfo", "IlluminaID","EnsemblReannotated", datacache, "ENSEMBLREANNOTATED","illuminaMousev2.db")

illuminaMousev2listNewMappings = function(){
cat("illuminaMousev2ARRAYADDRESS()\n") 
cat("illuminaMousev2NUID()\n") 
cat("illuminaMousev2PROBEQUALITY()\n") 
cat("illuminaMousev2CODINGZONE()\n") 
cat("illuminaMousev2PROBESEQUENCE()\n") 
cat("illuminaMousev2SECONDMATCHES()\n") 
cat("illuminaMousev2OTHERGENOMICMATCHES()\n") 
cat("illuminaMousev2REPEATMASK()\n") 
cat("illuminaMousev2OVERLAPPINGSNP()\n") 
cat("illuminaMousev2ENTREZREANNOTATED()\n") 
cat("illuminaMousev2GENOMICLOCATION()\n") 
cat("illuminaMousev2SYMBOLREANNOTATED()\n") 
cat("illuminaMousev2REPORTERGROUPNAME()\n") 
cat("illuminaMousev2REPORTERGROUPID()\n") 
cat("illuminaMousev2ENSEMBLREANNOTATED()\n") 
}
illuminaMousev2fullReannotation = function(){
dbGetQuery(illuminaMousev2_dbconn(), "SELECT * FROM ExtraInfo")
}
