\name{illuminaHumanv4listNewMappings}
\alias{illuminaHumanv4ARRAYADDRESS}
\alias{illuminaHumanv4NUID}
\alias{illuminaHumanv4PROBESEQUENCE}
\alias{illuminaHumanv4PROBEQUALITY}
\alias{illuminaHumanv4CODINGZONE}
\alias{illuminaHumanv4GENOMICLOCATION}
\alias{illuminaHumanv4GENOMICMATCHSIMILARITY}
\alias{illuminaHumanv4SECONDMATCHES}
\alias{illuminaHumanv4SECONDMATCHSIMILARITY}
\alias{illuminaHumanv4TRANSCRIPTOMICMATCHSIMILARITY}
\alias{illuminaHumanv4OTHERGENOMICMATCHES}
\alias{illuminaHumanv4REPEATMASK}
\alias{illuminaHumanv4OVERLAPPINGSNP}
\alias{illuminaHumanv4ENTREZREANNOTATED}
\alias{illuminaHumanv4ENSEMBLREANNOTATED}
\alias{illuminaHumanv4SYMBOLREANNOTATED}
\alias{illuminaHumanv4listNewMappings}
\alias{illuminaHumanv4fullReannotation}
\alias{illuminaHumanv4REPORTERGROUPNAME}
\alias{illuminaHumanv4REPORTERGROUPID}

\title{Custom mappings added to the package}
\description{
We have used an extensive re-annotation of the illuminaHumanv4 probe sequences to provide additional information that is not captured in the standard Bioconductor packages. Whereas Bioconductor annotations are based on the RefSeq ID that each probe maps to, our additional mappings provide data specific to each probe on the platform. See below for details. We recommend using the probe quality as a form of filtering, and retaining only perfect or good probes for an analysis. 

}

\section{Details of custom mappings}{

\describe{

\item{illuminaHumanv4listNewMappings}{List all the custom re-annotation mappings provided by the package}

\item{illuminaHumanv4fullReannotation}{Return all the re-annotation information as a matrix}

\item{illuminaHumanv4ARRAYADDRESS}{Array Address code used to identify the probe at the bead-level}

\item{illuminaHumanv4NUID}{Lumi's nuID (universal naming scheme for oligonucleotides) Reference: Du et al. (2007), Biol Direct 2:16}

\item{illuminaHumanv4PROBESEQUENCE}{The 50 base sequence for the probe}

\item{illuminaHumanv4PROBEQUALITY}{Quality grade assigned to the probe: \dQuote{Perfect} if it perfectly and uniquely matches the target transcript; \dQuote{Good} if the probe, although imperfectly matching the target transcript, is still likely to provide considerably sensitive signal (up to two mismatches are allowed, based on empirical evidence that the signal intensity for 50-mer probes with less than 95\% identity to the respective targets is less than 50\% of the signal associated with perfect matches *); \dQuote{Bad} if the probe matches repeat sequences, intergenic or intronic regions, or is unlikely to provide specific signal for any transcript; \dQuote{No match} if it does not match any genomic region or transcript.}

\item{illuminaHumanv4CODINGZONE}{Coding status of target sequence: intergenic / intronic / Transcriptomic (\dQuote{Transcriptomic} when the target transcript is non-coding or there is no information on the coding sequence)}

\item{illuminaHumanv4GENOMICLOCATION}{Probe's genomic coordinates (hg19 for human, mm9 for mouse or rn4 for rat)}

\item{illuminaHumanv4GENOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its best genomic match in the alignable region, taking the probe as reference}

\item{illuminaHumanv4SECONDMATCHES}{Genomic coordinates of second best matches between the probe and the genome}

\item{illuminaHumanv4SECONDMATCHSIMILARITY}{Percentage of similarity between the probe and its second best genomic match in the alignable region, taking the probe as reference}

\item{illuminaHumanv4TRANSCRIPTOMICMATCHSIMILARITY}{Percentage of similarity between the probe and its target transcript in the alignable region, taking the probe as reference}

\item{illuminaHumanv4OTHERGENOMICMATCHES}{Genomic coordinates of sequences as alignable with the probe (in terms of number of matching nucleotides) as its main target}

\item{illuminaHumanv4REPEATMASK}{Overlapping RepeatMasked sequences, with number of bases overlapped by the repeat}

\item{illuminaHumanv4OVERLAPPINGSNP}{Overlapping annotated SNPs}

\item{illuminaHumanv4ENTREZREANNOTATED}{Entrez IDs}

\item{illuminaHumanv4ENSEMBLREANNOTATED}{Ensembl IDs}

\item{illuminaHumanv4SYMBOLREANNOTATED}{Gene symbol derived by re-annotation}

\item{illuminaHumanv4REPORTERGROUPID}{For probes marked as controls in Illuminas annotation file, these gives the type of control}

\item{illuminaHumanv4REPORTERGROUPNAME}{Usually a more informative name for the control type}



}

}

\references{
  \url{http://remoat.sysbiol.cam.ac.uk}


 Barbosa-Morais et al. (2010) A re-annotation pipeline for Illumina BeadArrays: improving the interpretation of gene expression data. Nucleic Acids Research

}
\examples{

	##See what new mappings are available

	illuminaHumanv4listNewMappings()
	

        x <- illuminaHumanv4PROBEQUALITY

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBEQUALITY for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


	##Overall table of qualities
	table(unlist(xx))

	

        x <- illuminaHumanv4ARRAYADDRESS

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

	##Can do the mapping from array address to illumina ID using a revmap
	
	y<- revmap(illuminaHumanv4ARRAYADDRESS)
	
        mapped_probes <- mappedkeys(y)
        # Convert to a list
        yy <- as.list(y[mapped_probes])
        if(length(yy) > 0) {
          # Get the ARRAYADDRESS for the first five probes
          yy[1:5]
          # Get the first one
          yy[[1]]
        }
	


        x <- illuminaHumanv4CODINGZONE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the CODINGZONE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        x <- illuminaHumanv4PROBESEQUENCE

        mapped_probes <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_probes])
        if(length(xx) > 0) {
          # Get the PROBESEQUENCE for the first five probes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }


}
\keyword{datasets}
