datacache <- new.env(hash=TRUE, parent=emptyenv())

illuminaHumanv2BeadID <- function() showQCData("illuminaHumanv2BeadID", datacache)
illuminaHumanv2BeadID_dbconn <- function() dbconn(datacache)
illuminaHumanv2BeadID_dbfile <- function() dbfile(datacache)
illuminaHumanv2BeadID_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
illuminaHumanv2BeadID_dbInfo <- function() dbInfo(datacache)

illuminaHumanv2BeadIDORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "illuminaHumanv2BeadID.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "illuminaHumanv2BeadID", "chip illuminaHumanv2BeadID", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("illuminaHumanv2BeadID.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(illuminaHumanv2BeadID_dbconn())
}

