datacache <- new.env(hash=TRUE, parent=emptyenv())

hugene21sttranscriptcluster <- function() showQCData("hugene21sttranscriptcluster", datacache)
hugene21sttranscriptcluster_dbconn <- function() dbconn(datacache)
hugene21sttranscriptcluster_dbfile <- function() dbfile(datacache)
hugene21sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hugene21sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

hugene21sttranscriptclusterORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hugene21sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hugene21sttranscriptcluster", "chip hugene21sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hugene21sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hugene21sttranscriptcluster_dbconn())
}

