datacache <- new.env(hash=TRUE, parent=emptyenv())

huex10sttranscriptcluster <- function() showQCData("huex10sttranscriptcluster", datacache)
huex10sttranscriptcluster_dbconn <- function() dbconn(datacache)
huex10sttranscriptcluster_dbfile <- function() dbfile(datacache)
huex10sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
huex10sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

huex10sttranscriptclusterORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "huex10sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "huex10sttranscriptcluster", "chip huex10sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("huex10sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(huex10sttranscriptcluster_dbconn())
}

