datacache <- new.env(hash=TRUE, parent=emptyenv())

hta20transcriptcluster <- function() showQCData("hta20transcriptcluster", datacache)
hta20transcriptcluster_dbconn <- function() dbconn(datacache)
hta20transcriptcluster_dbfile <- function() dbfile(datacache)
hta20transcriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hta20transcriptcluster_dbInfo <- function() dbInfo(datacache)

hta20transcriptclusterORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hta20transcriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hta20transcriptcluster", "chip hta20transcriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hta20transcriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hta20transcriptcluster_dbconn())
}

