datacache <- new.env(hash=TRUE, parent=emptyenv())

hs25kresogen <- function() showQCData("hs25kresogen", datacache)
hs25kresogen_dbconn <- function() dbconn(datacache)
hs25kresogen_dbfile <- function() dbfile(datacache)
hs25kresogen_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hs25kresogen_dbInfo <- function() dbInfo(datacache)

hs25kresogenORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hs25kresogen.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hs25kresogen", "chip hs25kresogen", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hs25kresogen.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hs25kresogen_dbconn())
}

