## Configure

url <- "https://s3.amazonaws.com/NHLBI_public/GRASP/GraspFullDataset2.zip"
zip <- basename(url)
fname <- file.path(dirname(zip), "GRASP2fullDataset")
dbname <- file.path(dirname(fname), "BiocGRASP2.sqlite")

## Download & unzip

if (!file.exists(zip)) {
    library(httr)
    GET(url, write_disk(zip), progress())
}
if (!file.exists(fname))
    unzip(zip, fname)

## Process to initial sqlite

if (!file.exists(dbname))
    grasp2db:::.db_create(fname, dbname)
