datacache <- new.env(hash=TRUE, parent=emptyenv())

ecoli2 <- function() showQCData("ecoli2", datacache)
ecoli2_dbconn <- function() dbconn(datacache)
ecoli2_dbfile <- function() dbfile(datacache)
ecoli2_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
ecoli2_dbInfo <- function() dbInfo(datacache)

ecoli2ORGANISM <- "Escherichia coli"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "ecoli2.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ECOLICHIP_DB", "ecoli2", "chip ecoli2", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("ecoli2.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(ecoli2_dbconn())
}

