datacache <- new.env(hash=TRUE, parent=emptyenv())

drosophila2 <- function() showQCData("drosophila2", datacache)
drosophila2_dbconn <- function() dbconn(datacache)
drosophila2_dbfile <- function() dbfile(datacache)
drosophila2_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
drosophila2_dbInfo <- function() dbInfo(datacache)

drosophila2ORGANISM <- "Drosophila melanogaster"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "drosophila2.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("FLYCHIP_DB", "drosophila2", "chip drosophila2", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("drosophila2.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(drosophila2_dbconn())
}

