datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomsrattranscriptcluster <- function() showQCData("clariomsrattranscriptcluster", datacache)
clariomsrattranscriptcluster_dbconn <- function() dbconn(datacache)
clariomsrattranscriptcluster_dbfile <- function() dbfile(datacache)
clariomsrattranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomsrattranscriptcluster_dbInfo <- function() dbInfo(datacache)

clariomsrattranscriptclusterORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomsrattranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "clariomsrattranscriptcluster", "chip clariomsrattranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomsrattranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomsrattranscriptcluster_dbconn())
}

