
\name{clariomshumantranscriptcluster_dbconn}

\alias{clariomshumantranscriptcluster_dbconn}
\alias{clariomshumantranscriptcluster_dbfile}
\alias{clariomshumantranscriptcluster_dbschema}
\alias{clariomshumantranscriptcluster_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  clariomshumantranscriptcluster_dbconn()
  clariomshumantranscriptcluster_dbfile()
  clariomshumantranscriptcluster_dbschema(file="", show.indices=FALSE)
  clariomshumantranscriptcluster_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{clariomshumantranscriptcluster_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{clariomshumantranscriptcluster_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{clariomshumantranscriptcluster_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{clariomshumantranscriptcluster_dbschema} prints the schema definition of the
  package annotation DB.

  \code{clariomshumantranscriptcluster_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{clariomshumantranscriptcluster_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{clariomshumantranscriptcluster_dbfile}: a character string with the path to the
  package annotation DB.

  \code{clariomshumantranscriptcluster_dbschema}: none (invisible \code{NULL}).

  \code{clariomshumantranscriptcluster_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(clariomshumantranscriptcluster_dbconn(), "SELECT COUNT(*) FROM probes")

  clariomshumantranscriptcluster_dbschema()

  clariomshumantranscriptcluster_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

