datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomshumantranscriptcluster <- function() showQCData("clariomshumantranscriptcluster", datacache)
clariomshumantranscriptcluster_dbconn <- function() dbconn(datacache)
clariomshumantranscriptcluster_dbfile <- function() dbfile(datacache)
clariomshumantranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomshumantranscriptcluster_dbInfo <- function() dbInfo(datacache)

clariomshumantranscriptclusterORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomshumantranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "clariomshumantranscriptcluster", "chip clariomshumantranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomshumantranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomshumantranscriptcluster_dbconn())
}

