datacache <- new.env(hash=TRUE, parent=emptyenv())

clariomdhumantranscriptcluster <- function() showQCData("clariomdhumantranscriptcluster", datacache)
clariomdhumantranscriptcluster_dbconn <- function() dbconn(datacache)
clariomdhumantranscriptcluster_dbfile <- function() dbfile(datacache)
clariomdhumantranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
clariomdhumantranscriptcluster_dbInfo <- function() dbInfo(datacache)

clariomdhumantranscriptclusterORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "clariomdhumantranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "clariomdhumantranscriptcluster", "chip clariomdhumantranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("clariomdhumantranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(clariomdhumantranscriptcluster_dbconn())
}

