datacache <- new.env(hash=TRUE, parent=emptyenv())

ath1121501 <- function() showQCData("ath1121501", datacache)
ath1121501_dbconn <- function() dbconn(datacache)
ath1121501_dbfile <- function() dbfile(datacache)
ath1121501_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
ath1121501_dbInfo <- function() dbInfo(datacache)

ath1121501ORGANISM <- "Arabidopsis thaliana"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "ath1121501.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ARABIDOPSISCHIP_DB", "ath1121501", "chip ath1121501", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("ath1121501.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(ath1121501_dbconn())
}

