metadata <- data.frame(
    Title="Alternative Splicing Annotation for Homo sapiens (Human)",
    Description=paste("List of data frames containing alternative splicing",
                      "events per event type. Each splicing event is",
                      "characterised by its chromosome, strand, splice",
                      "junctions coordinates relevant to the type of event and",
                      "associated gene."),
    Species="Homo sapiens",
    RDataPath="alternativeSplicingEvents.hg19/alternativeSplicingEvents.hg19_V2.rda",
    TaxonomyId=9606,
    Genome="hg19",
    Maintainer="Nuno Agostinho <nunodanielagostinho@gmail.com>",
    RDataClass="list",
    DispatchClass="Rda",
    SourceUrl=paste("https://miso.readthedocs.io/en/fastmiso/annotation.html",
                    "http://rnaseq-mats.sourceforge.net/user_guide.htm",
                    "https://bitbucket.org/regulatorygenomicsupf/suppa",
                    "http://vastdb.crg.eu/libs/", sep=", "),
    SourceType="GFF",
    SourceVersion=NA_character_,
    DataProvider="MISO, VAST-TOOLS, UCSC",
    BiocVersion=package_version("3.6"),
    Coordinate_1_based=TRUE,
    ResourceName="alternativeSplicingEvents.hg19_V2.rda",
    Tags=(c("Human, Alternative, Splicing, Events, Annotation, hg19")))

write.csv(metadata, file="inst/extdata/metadata.csv", row.names=FALSE)
