\name{TxDb.Scerevisiae.UCSC.sacCer3.sgdGene}
\docType{package}

\alias{TxDb.Scerevisiae.UCSC.sacCer3.sgdGene-package}
\alias{TxDb.Scerevisiae.UCSC.sacCer3.sgdGene}
\alias{TxDb.Scerevisiae.UCSC.sacCer3.sgdGene}


\title{Annotation package for TxDb object(s)}

\description{  
  This package loads one or more TxDb objects.  Such TxDb
  objects are an R interface to prefabricated databases contained by
  this package.

  The names of any objects exposed by this package indicate the origin and
  resources exposed.  So for example TxDb.Hsapiens.UCSC.hg19.knownGene
  would be a TxDb object, of Homo sapiens data from UCSC build
  hg19 based on the knownGene Track.
}

\note{
  This data package was made from resources at UCSC on
  2015-10-07 18:20:42 +0000 (Wed, 07 Oct 2015) and based on the sacCer3 genome based on the sgdGene table
}

\author{Marc Carlson, Bioconductor Package Maintainer <maintainer@bioconductor.org> [cre]}


\seealso{
  \link[GenomicFeatures]{transcripts},
  \link[GenomicFeatures]{transcriptsBy}
}

\examples{
## load the library
library(TxDb.Scerevisiae.UCSC.sacCer3.sgdGene)
## list the contents that are loaded into memory
ls('package:TxDb.Scerevisiae.UCSC.sacCer3.sgdGene')
## show the db object that is loaded by calling it's name
TxDb.Scerevisiae.UCSC.sacCer3.sgdGene

}

\keyword{package}
\keyword{data}
