\name{TxDb.Ggallus.UCSC.galGal5.refGene}
\docType{package}

\alias{TxDb.Ggallus.UCSC.galGal5.refGene-package}
\alias{TxDb.Ggallus.UCSC.galGal5.refGene}
\alias{TxDb.Ggallus.UCSC.galGal5.refGene}


\title{Annotation package for TxDb object(s)}

\description{  
  This package loads one or more TxDb objects.  Such TxDb
  objects are an R interface to prefabricated databases contained by
  this package.

  The names of any objects exposed by this package indicate the origin and
  resources exposed.  So for example TxDb.Hsapiens.UCSC.hg19.knownGene
  would be a TxDb object, of Homo sapiens data from UCSC build
  hg19 based on the knownGene Track.
}

\note{
  This data package was made from resources at UCSC on
  2020-10-11 17:30:29 +0000 (Sun, 11 Oct 2020) and based on the galGal5 genome based on the refGene table
}

\author{Bioconductor Core Team, Bioconductor Package Maintainer <maintainer@bioconductor.org> [cre]}


\seealso{
  \link[GenomicFeatures]{transcripts},
  \link[GenomicFeatures]{transcriptsBy}
}

\examples{
## load the library
library(TxDb.Ggallus.UCSC.galGal5.refGene)
## list the contents that are loaded into memory
ls('package:TxDb.Ggallus.UCSC.galGal5.refGene')
## show the db object that is loaded by calling it's name
TxDb.Ggallus.UCSC.galGal5.refGene

}

\keyword{package}
\keyword{data}
