\name{TxDb.Cfamiliaris.UCSC.canFam3.refGene}
\docType{package}

\alias{TxDb.Cfamiliaris.UCSC.canFam3.refGene-package}
\alias{TxDb.Cfamiliaris.UCSC.canFam3.refGene}
\alias{TxDb.Cfamiliaris.UCSC.canFam3.refGene}


\title{Annotation package for TxDb object(s)}

\description{  
  This package loads one or more TxDb objects.  Such TxDb
  objects are an R interface to prefabricated databases contained by
  this package.

  The names of any objects exposed by this package indicate the origin and
  resources exposed.  So for example TxDb.Hsapiens.UCSC.hg19.knownGene
  would be a TxDb object, of Homo sapiens data from UCSC build
  hg19 based on the knownGene Track.
}

\note{
  This data package was made from resources at UCSC on
  2020-04-28 14:19:25 +0000 (Tue, 28 Apr 2020) and based on the canFam3 genome based on the refGene table
}

\author{Bioconductor Core Team, Bioconductor Package Maintainer <maintainer@bioconductor.org> [cre]}


\seealso{
  \link[GenomicFeatures]{transcripts},
  \link[GenomicFeatures]{transcriptsBy}
}

\examples{
## load the library
library(TxDb.Cfamiliaris.UCSC.canFam3.refGene)
## list the contents that are loaded into memory
ls('package:TxDb.Cfamiliaris.UCSC.canFam3.refGene')
## show the db object that is loaded by calling it's name
TxDb.Cfamiliaris.UCSC.canFam3.refGene

}

\keyword{package}
\keyword{data}
