datacache <- new.env(hash=TRUE, parent=emptyenv())

PartheenMetaData <- function() showQCData("PartheenMetaData", datacache)
PartheenMetaData_dbconn <- function() dbconn(datacache)
PartheenMetaData_dbfile <- function() dbfile(datacache)
PartheenMetaData_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
PartheenMetaData_dbInfo <- function() dbInfo(datacache)

PartheenMetaDataORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "PartheenMetaData.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "PartheenMetaData", "chip PartheenMetaData", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("PartheenMetaData.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(PartheenMetaData_dbconn())
}

