datacache <- new.env(hash=TRUE, parent=emptyenv())

OperonHumanV3 <- function() showQCData("OperonHumanV3", datacache)
OperonHumanV3_dbconn <- function() dbconn(datacache)
OperonHumanV3_dbfile <- function() dbfile(datacache)
OperonHumanV3_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
OperonHumanV3_dbInfo <- function() dbInfo(datacache)

OperonHumanV3ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "OperonHumanV3.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "OperonHumanV3", "chip OperonHumanV3", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("OperonHumanV3.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(OperonHumanV3_dbconn())
}

