% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gencode_annotated_genes.R
\name{gencode_annotated_genes}
\alias{gencode_annotated_genes}
\title{Annotation the genes for a given Gencode TxDb object}
\usage{
gencode_annotated_genes(txdb)
}
\arguments{
\item{txdb}{A \link[GenomicFeatures:TxDb-class]{GenomicFeatures::TxDb} object built with
\code{\link[=gencode_txdb]{gencode_txdb()}}.}
}
\value{
The annotated genes resulting from
\code{\link[bumphunter:annotateTranscripts]{bumphunter::annotateTranscripts()}}.
}
\description{
Based on a \code{TxDb} object built by \code{\link[=gencode_txdb]{gencode_txdb()}} this function annotates
the genes. This information is then used by packages like \code{derfinder} and
\code{derfinderPlot}.
}
\examples{

## Start from scratch if you want:
\dontrun{
txdb_v31_hg19_chr21 <- gencode_txdb("31", "hg19", chrs = "chr21")
}

## or read in the txdb object for hg19 chr21 from this package
txdb_v31_hg19_chr21 <- AnnotationDbi::loadDb(
    system.file("extdata", "txdb_v31_hg19_chr21.sqlite",
        package = "GenomicState"
    )
)

## Obtain the annotated genes for the Gencode TxDb object
genes_v31_hg19_chr21 <- gencode_annotated_genes(txdb_v31_hg19_chr21)

## Explore the result
genes_v31_hg19_chr21
}
\references{
Based on code for the \code{brainflowprobes} package at:
\url{https://github.com/LieberInstitute/brainflowprobes/blob/devel/data-raw/create_sysdata.R}
}
\seealso{
\code{\link[=gencode_txdb]{gencode_txdb()}} \code{\link[=gencode_genomic_state]{gencode_genomic_state()}}
}
\author{
Leonardo Collado-Torres.
}
