% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicStateHub.R
\name{GenomicStateHub}
\alias{GenomicStateHub}
\title{Access GenomicState objects through AnnotationHub}
\usage{
GenomicStateHub(
  version = "31",
  genome = c("hg38", "hg19"),
  filetype = c("TxDb", "AnnotatedGenes", "GenomicState"),
  ah = AnnotationHub::AnnotationHub()
)
}
\arguments{
\item{version}{A \code{character(1)} with the Gencode version number.}

\item{genome}{A \code{character(1)} with the human genome version number. Valid
options are \code{'hg38'} or \code{'hg19'}.}

\item{filetype}{A \code{character()} with either \code{TxDb}, \code{AnnotatedGenes} or
\code{GenomicState}.}

\item{ah}{An \code{AnnotationHub} object
\link[AnnotationHub:AnnotationHub-class]{AnnotationHub-class}.}
}
\value{
The \link[AnnotationHub:AnnotationHub-class]{AnnotationHub-class} query
for the file you requested.
}
\description{
This function uses \code{AnnotationHub} to obtain the objects provided by this
package. These are: the \code{TxDb} object made with \code{\link[=gencode_txdb]{gencode_txdb()}}, the
annotated genes object made with \code{\link[=gencode_annotated_genes]{gencode_annotated_genes()}} or the
GenomicState object made with \code{\link[=gencode_genomic_state]{gencode_genomic_state()}}.
}
\examples{

## Query AnnotationHub for the GenomicState object for Gencode v31 on
## hg19 coordinates
hub_query_gs_gencode_v31_hg19 <- GenomicStateHub(
    version = "31",
    genome = "hg19",
    filetype = "GenomicState"
)
hub_query_gs_gencode_v31_hg19


## Check the metadata
mcols(hub_query_gs_gencode_v31_hg19)

## Access the file through AnnotationHub
if (length(hub_query_gs_gencode_v31_hg19) == 1) {
    hub_gs_gencode_v31_hg19 <- hub_query_gs_gencode_v31_hg19[[1]]

    hub_gs_gencode_v31_hg19
}
}
\seealso{
\code{\link[=gencode_txdb]{gencode_txdb()}} \code{\link[=gencode_annotated_genes]{gencode_annotated_genes()}}
\code{\link[=gencode_genomic_state]{gencode_genomic_state()}}
}
\author{
Leonardo Collado-Torres
}
