lift27kToHg19 <- function(x) {
  stopifnot(is(x, 'SummarizedExperiment'))
  hm27 <- get27k(genome='hg19')
  start(hm27) <- end(hm27) <- hm27$probeTarget ## narrow to 1bp
  keep <- intersect(rownames(x), names(hm27))
  x <- x[ keep, ]
  rowData(x) <- hm27[ keep ]
  return(x)
}

hm27ToHg19 <- lift27kToHg19
