getPlatform <- function(platform = "HM450", ...) {

    ## if we are passed a MethyLumiSet or MethyLumiM *object*
    if(class(platform) %in% c('MethyLumiM','MethyLumiSet')) {
      getPlatform(getMethylationChipName(platform))
    }

    message('Fetching coordinates for hg19...')
    GR <- features(FDb.InfiniumMethylation.hg19)
    if("name" %in% names(mcols(GR))) names(GR) <- mcols(GR)$name
    if(any(is.na(unique(genome(GR))))) genome(GR) <- genome

    ## seqinfo(GR) <- SeqinfoForBSGenome(unique(genome(GR)))[seqlevels(GR)]
    data(seqinfo.hg19)
    seqinfo(GR) <- seqinfo.hg19[seqlevels(GR)]

    platform <- toupper(platform)
    if (platform == "HM450") {
        hm450.controls <- NULL
        data(hm450.controls)
        GR <- GR[which(mcols(GR)$platform %in% c("HM450", "BOTH"))]
        mcols(GR)$channel <- Rle(as.factor(mcols(GR)$channel450))
        mcols(GR)$addressA <- mcols(GR)$addressA_450
        mcols(GR)$addressB <- mcols(GR)$addressB_450
        attr(GR, "controls") <- hm450.controls
    }
    else if (platform == "HM27") {
        hm27.controls <- NULL
        data(hm27.controls)
        GR <- GR[which(mcols(GR)$platform %in% c("HM27", "BOTH"))]
        mcols(GR)$channel <- Rle(as.factor(mcols(GR)$channel27))
        mcols(GR)$addressA <- mcols(GR)$addressA_27
        mcols(GR)$addressB <- mcols(GR)$addressB_27
        attr(GR, "controls") <- hm27.controls
    }
    else {
        stop("You need to specify either HM27 or HM450 as platform to run")
    }
    mcols(GR)$percentGC <- as.numeric(mcols(GR)$percentGC)
    mcols(GR)$probeType <- Rle(as.factor(mcols(GR)$probeType))
    mcols(GR)$platform <- Rle(as.factor(mcols(GR)$platform))
    mcols(GR)$sourceSeq <- DNAStringSet(mcols(GR)$sourceSeq)
    mcols(GR)$probeRange <- IRanges( as.numeric(mcols(GR)$probeStart),
                                      as.numeric(mcols(GR)$probeEnd) )
    mcols(GR)$probeTarget <- as.numeric(mcols(GR)$probeTarget)
    kept = c("addressA", "addressB", "channel", 
             "platform", "percentGC", "sourceSeq",
             "probeType","probeStart","probeEnd","probeTarget")
    val <- mcols(GR)[, kept]
    mcols(GR) <- val
    strand(GR) <- '*'
    return(keepSeqlevels(sort(GR), paste0('chr', c(1:22,'X','Y'))))
}
