% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENCODExplorerData.R
\name{encode_df_lite}
\alias{encode_df_lite}
\title{ENCODE file metadata, Light version}
\format{A data table}
\description{
Metadata for the files made available by ENCODE database as a 
\code{\link[data.table]{data.table}} object. See \code{inst/scripts/make-data.R}
for the generation process. \code{encode_df_lite} contains a curated
subset of the full metadata and is faster to load and easier to work
with than \code{\link{encode_df_full}}.
}
\examples{
    # You can use AnnotationHub to retrieve encode_df_lite.
    library(AnnotationHub)
    hub <- AnnotationHub()
    myfiles <- subset(hub, title=="ENCODE File Metadata (Light, 2019-04-12 build)")

    # You can then have a look at the metadata of the retrieved object.
    myfiles

    # Finally, you can access the data.table itself by indexing into the 
    # object returned by subset.
    myfiles[[1]]
}
\seealso{
\code{\link{generate_encode_df_lite}}, \code{\link{encode_df_full}}
}
