###
###

.pkgname <- "BSgenome.Scerevisiae.UCSC.sacCer1"

.seqnames <- paste("chr", c(1:16, "M"), sep="")

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Saccharomyces cerevisiae",
        species="Yeast",
        provider="UCSC",
        provider_version="sacCer1",
        release_date="Oct. 2003",
        release_name="SGD 1 Oct 2003 sequence",
        source_url="http://hgdownload.cse.ucsc.edu/goldenPath/sacCer1/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Scerevisiae"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

