\name{BSgenome.Rnorvegicus.UCSC.rn7}
\docType{package}

\alias{BSgenome.Rnorvegicus.UCSC.rn7-package}
\alias{BSgenome.Rnorvegicus.UCSC.rn7}
\alias{Rnorvegicus}

\title{Full genome sequences for Rattus norvegicus (UCSC genome rn7)}

\description{
  Full genome sequences for Rattus norvegicus (Rat) as provided by UCSC (genome rn7) and stored in Biostrings objects.
}

\details{
  
}

\note{
  This BSgenome data package was made from the following source data files:
  \preformatted{
rn7.2bit, downloaded from https://hgdownload.soe.ucsc.edu/goldenPath/rn7/bigZips/ on August 24, 2021
  }

  See \code{?\link[BSgenome]{BSgenomeForge}} and the BSgenomeForge
  vignette (\code{vignette("BSgenomeForge")}) in the \pkg{BSgenome}
  software package for how to make a BSgenome data package.
}

\author{The Bioconductor Dev Team}

\seealso{
  \itemize{
    \item \link[BSgenome]{BSgenome} objects and the
          \code{\link[BSgenome]{available.genomes}} function
          in the \pkg{BSgenome} software package.
    \item \link[Biostrings]{DNAString} objects in the \pkg{Biostrings}
          package.
    \item The BSgenomeForge vignette (\code{vignette("BSgenomeForge")})
          in the \pkg{BSgenome} software package for how to make a BSgenome
          data package.
  }
}

\examples{
BSgenome.Rnorvegicus.UCSC.rn7
genome <- BSgenome.Rnorvegicus.UCSC.rn7
head(seqlengths(genome))
genome$chr1  # same as genome[["chr1"]]

## ---------------------------------------------------------------------
## Genome-wide motif searching
## ---------------------------------------------------------------------
## See the GenomeSearching vignette in the BSgenome software
## package for some examples of genome-wide motif searching using
## Biostrings and the BSgenome data packages:
if (interactive())
    vignette("GenomeSearching", package="BSgenome")
}

\keyword{package}
\keyword{data}
