###
###

.pkgname <- "BSgenome.Rnorvegicus.UCSC.rn7"

.seqnames <- NULL

.circ_seqs <- "chrM"

.mseqnames <- NULL

.onLoad <- function(libname, pkgname)
{
    if (pkgname != .pkgname)
        stop("package name (", pkgname, ") is not ",
             "the expected name (", .pkgname, ")")
    extdata_dirpath <- system.file("extdata", package=pkgname,
                                   lib.loc=libname, mustWork=TRUE)

    ## Make and export BSgenome object.
    bsgenome <- BSgenome(
        organism="Rattus norvegicus",
        common_name="Rat",
        genome="rn7",
        provider="UCSC",
        release_date="Nov. 2020",
        source_url="https://hgdownload.soe.ucsc.edu/goldenPath/rn7/bigZips/",
        seqnames=.seqnames,
        circ_seqs=.circ_seqs,
        mseqnames=.mseqnames,
        seqs_pkgname=pkgname,
        seqs_dirpath=extdata_dirpath
    )

    ns <- asNamespace(pkgname)

    objname <- pkgname
    assign(objname, bsgenome, envir=ns)
    namespaceExport(ns, objname)

    old_objname <- "Rnorvegicus"
    assign(old_objname, bsgenome, envir=ns)
    namespaceExport(ns, old_objname)
}

